<?php

defined('BASEPATH') or exit('No direct script access allowed');


/**
 * Get items table for preview
 * @param  object  $transaction   e.q. invoice, estimate from database result row
 * @param  string  $type          type, e.q. invoice, estimate, proposal
 * @param  string  $for           where the items will be shown, html or pdf
 * @param  boolean $admin_preview is the preview for admin area
 * @return object
 */
function get_yu_pdf_items_table_data($transaction, $type, $for = 'html', $admin_preview = false)
{
    // print_r("dasdsadasd");
    // exit;
    include_once(APPPATH . '../modules/yu_pdf/libraries/yu_pdf_library.php');
    $class = new Yu_pdf_library($transaction, $type, $for, $admin_preview);

    $class = hooks()->apply_filters('items_table_class', $class, $transaction, $type, $for, $admin_preview);

    if (!$class instanceof App_items_table_template) {
        show_error(get_class($class) . ' must be instance of "App_items_template"');
    }

    return $class;
}


/**
 * Prepare general invoice pdf
 * @param  object $invoice Invoice as object with all necessary fields
 * @param  string $tag     tag for bulk pdf exporter
 * @return mixed object
 */
function yu_invoice_pdf($invoice, $tag = '')
{
    return yu_app_pdf('invoice', LIBSPATH . '../../modules/yu_pdf/libraries/pdf/Invoice_pdf.php', $invoice, $tag);
}


function yu_app_pdf($type, $path, ...$params)
{
    $basename = ucfirst(basename(strbefore($path, EXT)));

    if (!endsWith($path, EXT)) {
        $path .= EXT;
    }

    // print_r( include_once($path));
    // exit;
    $path = hooks()->apply_filters("{$type}_pdf_class_path", $path, ...$params);

    include_once($path);

    return (new $basename(...$params))->prepare();
}