<script type="text/javascript">
(function($) {
  "use strict";
    $.get(admin_url + 'ma/get_data_email_template_chart').done(function(res) {
    res = JSON.parse(res);

    Highcharts.chart('container_chart', {
      chart: {
          type: 'area'
      },
      title: {
          text: '<?php echo _l("email_stats"); ?>'
      },
      time: {
            timezone: $('input[name=timezone]').val()
        },
      xAxis: {
          type: 'datetime',
          labels: {
              format: '{value:%Y-%m-%d}',
              rotation: 45,
              align: 'left'
          }
      },
      yAxis: {
          title: {
              text: ''
          }
      },
      credits: {
          enabled: false
      },
      series: res.data_email_template
    });
  });


  // Initialize datepickers
  // $('.datepicker').datepicker({
  //   format: 'yyyy-mm-dd',
  //   autoclose: true,
  //   todayHighlight: true
  // });

  // Load table on filter click
$('#filter_submit').on('click', function () {
  const startDate = $('#start_date').val();
  const endDate = $('#end_date').val();
  const delivered = $('#filter_delivered').val();
  const opened = $('#filter_opened').val();
  const clicked = $('#filter_clicked').val();
  const email_template_id=$('#email_template_filter').val();
  const campaign_id=$('#campaign_filter').val();

  if(startDate=='' && endDate=='' && delivered=='' && opened=='' && clicked=='' && email_template_id=='' && campaign_id==''){
    alert("Please select any filter option");
  } else {
    init_email_log_table(startDate, endDate, delivered, opened, clicked, email_template_id, campaign_id);
  }  
});

$('#export_excel').on('click', function (e) {
  e.preventDefault();

  const startDate = $('#start_date').val();
  const endDate = $('#end_date').val();
  const delivered = $('#filter_delivered').val();
  const opened = $('#filter_opened').val();
  const clicked = $('#filter_clicked').val();
  const email_template_id=$('#email_template_filter').val();
  const campaign_id=$('#campaign_filter').val();

const url = '<?= admin_url('ma/export_email_logs_excel') ?>?' + $.param({
  delivered: $('#filter_delivered').val(),
  opened: $('#filter_opened').val(),
  clicked: $('#filter_clicked').val(),
  email_template_id: $('#email_template_filter').val(),
  campaign_id: $('#campaign_filter').val(),
  start_date: $('#start_date').val(),
  end_date: $('#end_date').val(),
});

  if(startDate=='' && endDate=='' && delivered=='' && opened=='' && clicked=='' && email_template_id=='' && campaign_id==''){
    alert("Please select any filter option");
  } else {
    window.open(url, '_blank');
  }

});

  // Load default table
  //init_email_log_table();

  init_email_log_table();
})(jQuery);

// function init_email_log_table() {
// "use strict";

//  if ($.fn.DataTable.isDataTable('.table-email-logs')) {
//    $('.table-email-logs').DataTable().destroy();
//  }
//  initDataTable('.table-email-logs', admin_url + 'ma/email_log_table', false, false, [], [0, 'desc']);
// }

function init_email_log_table(startDate = '', endDate = '', delivered = '', opened = '', clicked = '', email_template_id = '', campaign_id = '') {

  if ($.fn.DataTable.isDataTable('.table-email-logs')) {
    $('.table-email-logs').DataTable().destroy();
  }

  const url = admin_url + 'ma/email_log_table?' +
              'start_date=' + startDate +
              '&end_date=' + endDate +
              '&delivered=' + delivered +
              '&opened=' + opened +
              '&clicked=' + clicked +
              '&email_template_id=' + email_template_id +
              '&campaign_id=' + campaign_id;

  initDataTable('.table-email-logs', url, false, false, [], [0, 'desc']);
}
</script>