<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: YU Invoices CRM Module
Description: Sample module description.
Version: 1.1.0
Requires at least: 2.3.*
*/

hooks()->add_action('admin_init', 'yuInvoices_module_init_menu_items');

function yuInvoices_module_init_menu_items()
{
    $CI = &get_instance();

    // Adding To-Do List menu item
    $CI->app_menu->add_sidebar_menu_item('yuInvoices-menu', [
        'name'     => 'Yu-Invoice',
        'href'     => admin_url('yu_invoices'), // Adjust if using custom controller routes
        'icon'     => 'fa fa-check-circle',
        'position' => 35,
    ]);

    // Example of custom invoice link for testing
    // $CI->app_menu->add_sidebar_menu_item('custom-invoice', [
    //     'name'     => 'Custom Invoice',
    //     'href'     => admin_url('yuInvoices/invoices/invoice/1'), // Replace '1' with dynamic ID if needed
    //     'icon'     => 'fa fa-file-invoice-dollar',
    //     'position' => 15,
    // ]);
}

// Activation hook
register_activation_hook('yu_invoices', 'yuInvoices_module_activation_hook');
function yuInvoices_module_activation_hook()
{
    $CI = &get_instance();

    // Create table if it doesn't exist
    if ($CI->db->table_exists(db_prefix() . 'invoices')) {
        // Check if invoice_no column exists
        // print_r("yuInvoices_module_activation_hook");
        // exit;
        if (!$CI->db->field_exists('invoice_no', db_prefix() . 'invoices')) {
            // Add the invoice_no column with default NULL
            $CI->db->query('ALTER TABLE `' . db_prefix() . "invoices` 
                ADD COLUMN `invoice_no` varchar(255) DEFAULT NULL;");
        }
        if (!$CI->db->field_exists('invoice_type', db_prefix() . 'invoices')) {
            // Add the invoice_no column with default NULL
            $CI->db->query('ALTER TABLE `' . db_prefix() . "invoices` 
                ADD COLUMN `invoice_type` varchar(255) DEFAULT NULL;");
        }
    }
}
