<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <?php
            echo form_open($this->uri->uri_string(), ['id' => 'invoice-form', 'class' => '_transaction_form invoice-form']);
            if (isset($invoice)) {
                echo form_hidden('isedit');
            }
            ?>
            <div class="col-md-12">
                <h4
                    class="tw-mt-0 tw-font-semibold tw-text-lg tw-text-neutral-700 tw-flex tw-items-center tw-space-x-2">
                    <span>
                        <?php echo isset($invoice) ? format_invoice_number($invoice) : _l('create_new_invoice'); ?>
                    </span>
                    <?php echo isset($invoice) ? format_invoice_status($invoice->status) : ''; ?>
                </h4>
                <?php $this->load->view('admin/invoices/invoice_template'); ?>
            </div>
            <?php echo form_close(); ?>
            <?php $this->load->view('admin/invoice_items/item'); ?>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
    $(document).ready(function() {
        // Function to handle the change event
        $('select[name="allowed_payment_modes[]"]').on('change', function() {
            var selectedValues = $(this).val();

            // Hide all elements initially
            $('#hdfc_bank').hide();
            $('#icici_bank').hide();
            $('#razor_pay').hide();
            $('#upi').hide();

            // $('#razorpay').hide(); // Add this line if you have an element for Razor Pay

            // Loop through the selected values and show the corresponding elements
            $.each(selectedValues, function(index, value) {
                if (value == 1) {
                    $('#hdfc_bank').show();
                } else if (value == 2) {
                    $('#icici_bank').show();
                } else if (value == 3) {
                    $('#razor_pay').show(); // Uncomment this line if you have an element for Razor Pay
                } else if (value == 4) {
                    $('#upi').show()
                }
            });
        });

        // Trigger change event on page load to handle pre-selected values
        $('select[name="allowed_payment_modes[]"]').trigger('change');


        $("#invoice_type").on('change', function() {


            if ($(this).val() == 'YSL/DI/') {

                $('#prefix').html('YSL/DI/');
                $('#prefix_hidden').val('YSL/DI/');

                getNextNo = $('#invoice_next_noInd').val();
                $('#invoiceNextNo').val(getNextNo);
                $('#invoice_no').val('YSL/DI/' + getNextNo);
                $('#number').val(getNextNo);


            } else if ($(this).val() == 'YSL/EI/') {

                $('#prefix_hidden').val('YSL/EI/');
                getNextNo = $('#invoice_next_noInt').val();
                $('#invoiceNextNo').val(getNextNo);
                $('#invoice_no').val('YSL/EI/' + getNextNo);
                $('#number').val(getNextNo);
                $('#prefix').html('YSL/EI/');
            }

        });
    });
    // console.log("Invoice Script")
    $("#invoiceNextNo").on('change', function() {
        $("#number").val($("#invoiceNextNo").val())
    });


    $("#invoice_type").on('change', function() {


        if ($(this).val() == 'YSL/DI/') {

            $('#prefix').html('YSL/DI/');
            $('#prefix_hidden').val('YSL/DI/');

            getNextNo = $('#invoice_next_noInd').val();
            $('#invoiceNextNo').val(getNextNo);
            $('#invoice_no').val('YSL/DI/' + getNextNo);
            $('#number').val(getNextNo);


        } else if ($(this).val() == 'YSL/EI/') {

            $('#prefix_hidden').val('YSL/EI/');
            getNextNo = $('#invoice_next_noInt').val();
            $('#invoiceNextNo').val(getNextNo);
            $('#invoice_no').val('YSL/EI/' + getNextNo);
            $('#number').val(getNextNo);
            $('#prefix').html('YSL/EI/');
        }

    });
</script>
<script>
    $(function() {
        validate_invoice_form();
        // Init accountacy currency symbol
        init_currency();
        // Project ajax search
        init_ajax_project_search_by_customer_id();
        // Maybe items ajax search
        init_ajax_search('items', '#item_select.ajax-search', undefined, admin_url + 'items/search');
    });
</script>
</body>

</html>