<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head();?>
<div id="wrapper">
  <div class="content">
    <div class="row">
      <div class="panel_s">
        <div class="panel-body">
          <h4 class="no-margin font-bold"><?php echo _l($title); ?></h4>
          <a href="<?php echo admin_url('ma/reports'); ?>"><?php echo _l('back_to_report_list'); ?></a>
          <?php echo form_hidden('timezone', date_default_timezone_get()); ?>
          <hr />
          <div id="container_chart"></div>
<div class="row mtop15 filter">
  <div class="col-md-2 filter">
    <label>Start Date</label>
    <input type="text" id="start_date" class="form-control datepicker" autocomplete="off">
  </div>
  <div class="col-md-2 filter">
    <label>End Date</label>
    <input type="text" id="end_date" class="form-control datepicker" autocomplete="off">
  </div>
  <div class="col-md-1 filter">
    <label>Delivered</label>
    <select id="filter_delivered" class="form-control">
      <option value="">All</option>
      <option value="1">Yes</option>
      <option value="0">No</option>
    </select>
  </div>
  <div class="col-md-1 filter">
    <label>Opened</label>
    <select id="filter_opened" class="form-control">
      <option value="">All</option>
      <option value="1">Yes</option>
      <option value="0">No</option>
    </select>
  </div>
  <div class="col-md-1 filter">
    <label>Clicked</label>
    <select id="filter_clicked" class="form-control">
      <option value="">All</option>
      <option value="1">Yes</option>
      <option value="0">No</option>
    </select>
  </div>
  <div class="col-md-2 filter">
    <label>Email Templates</label>
<!-- Email Template Dropdown -->
<select id="email_template_filter" class="form-control">

    <option value="">All Email Templates</option>
    <?php foreach ($email_templates as $template) { ?>
        <option value="<?= $template['id'] ?>"><?= $template['name'] ?></option>
    <?php } ?>
</select>
</div>
  <div class="col-md-2 filter">
<!-- Campaign Dropdown -->
<label>Campaigns</label>
<select id="campaign_filter" class="form-control">
  
    <option value="">All Campaigns</option>
    <?php foreach ($campaigns as $campaign) { ?>
        <option value="<?= $campaign['id'] ?>"><?= $campaign['name'] ?></option>
    <?php } ?>
</select>
</div>

  <div class="col-md-1 filter">
    <div class="col-md-6 filter">
      <label>&nbsp;</label>
      <button title="Apply Filter" class="btn btn-primary btn-block" id="filter_submit"><i class="fa-solid fa-filter"></i></button>
    </div>
    <div class="col-md-6 filter">
      <label>&nbsp;</label>
      <a href="#" class="btn btn-success btn-block" id="export_excel" title="Download CSV"><i class="fa-solid fa-download"></i></a>
    </div>
  </div>
</div>
<br/>

          <table class="table table-email-logs mtop25">
            <thead>
              <th><?php echo _l('time'); ?></th>
              <th><?php echo _l('campaign_name'); ?></th>
              <th><?php echo _l('email_template'); ?></th>
              <th><?php echo _l('contact_type'); ?></th>
              <th><?php echo _l('contact_name'); ?></th>
              <th><?php echo _l('email'); ?></th>
              <th><?php echo _l('delivery'); ?></th>
              <th><?php echo _l('open'); ?></th>
              <th><?php echo _l('click'); ?></th>
            </thead>
            <tbody>
            </tbody>
          </table>
      </div>
    </div>
  </div>
</div>
<!-- box loading -->
<div id="box-loading"></div>
<?php init_tail(); ?>
</body>
<style type="text/css">
  .filter, .filter > input, .filter > select, .filter > label{
    font-size: 12px !important;
  }
  .filter {
    padding: 0px 5px 0px 5px !important;
  }
</style>
</html>
<?php require('modules/ma/assets/js/reports/email_report_js.php'); ?>
