var fnServerParams;
(function($) {
    "use strict";
    fnServerParams = {
        "category": '[name="category"]',
    };
    $('select[name="category"]').on('change', function() {
        init_email_table();
    });
    
    init_email_table();
})(jQuery);

function init_email_table() {
    "use strict";
    if ($.fn.DataTable.isDataTable('.table-emails')) {
        $('.table-emails').DataTable().destroy();
    }
    
    // Initialize the table
    var table = initDataTable('.table-emails', admin_url + 'ma/email_table', false, false, fnServerParams);
    
    // Remove any existing draw event handlers to prevent duplicates
    $('.table-emails').off('draw.dt.smtpValidation');
    
    // Add our validator after table draw
    $('.table-emails').on('draw.dt.smtpValidation', function() {
        // Wait for table to fully render
        setTimeout(function() {
            // Start validation process with direct credentials
            validateSmtpWithDirectCredentials();
        }, 1000);
    });
}

/**
 * Execute SMTP validation using directly embedded credentials
 */
function validateSmtpWithDirectCredentials() {
    // Our validation cache - indexed by credential key (email|password)
    var validationCache = {};
    
    // Group rows by credential key
    var rowGroups = {};
    var uniqueCredentials = [];
    
    // First pass: identify unique credential sets and group rows
    $('.table-emails tbody tr').each(function() {
        var $row = $(this);
        var email = $row.data('email');
        var password = $row.data('password');
        var credKey = $row.data('cred-key');
        var $statusCell = $row.find('td:nth-child(5)');
        
        // Only process rows with credentials and success status (valid format)
        if (credKey && email && password && $statusCell.find('.text-muted').length > 0) {
            // If this is the first time we've seen this credential set
            if (!rowGroups[credKey]) {
                rowGroups[credKey] = [];
                
                // Add to list of unique credentials
                uniqueCredentials.push({
                    key: credKey,
                    email: email,
                    password: password
                });
            }
            
            // Add this row to the appropriate group
            rowGroups[credKey].push({
                row: $row,
                statusCell: $statusCell,
                originalHtml: $statusCell.html()
            });
        }
    });
    
    var uniqueCount = uniqueCredentials.length;
    var totalRows = Object.values(rowGroups).reduce((sum, rows) => sum + rows.length, 0);
    
    // No credentials to validate
    if (uniqueCount === 0) {
        console.log('No emails need SMTP validation');
        return;
    }
    
    console.log(`Found ${uniqueCount} unique credential sets affecting ${totalRows} rows`);
    
    // Show status indicator
    var $statusIndicator = $('<div id="smtp-validation-status" class="alert alert-info">' +
                           `SMTP Validation: 0/${uniqueCount} unique credential sets ` +
                           '<i class="fa fa-spinner fa-spin"></i></div>');
    
    if ($('#smtp-validation-status').length === 0) {
        $('.table-emails').before($statusIndicator);
    } else {
        $('#smtp-validation-status').html(`SMTP Validation: 0/${uniqueCount} unique credential sets ` +
                                         '<i class="fa fa-spinner fa-spin"></i>');
    }
    
    // Validate each unique credential set
    function validateNextCredential(index) {
        if (index >= uniqueCredentials.length) {
            // All done
            $('#smtp-validation-status').removeClass('alert-info').addClass('alert-success')
                .html(`SMTP Validation Complete: ${uniqueCredentials.length}/${uniqueCount} credential sets validated ` +
                     '<i class="fa fa-check"></i>');
            
            setTimeout(function() {
                $('#smtp-validation-status').fadeOut(function() {
                    $(this).remove();
                });
            }, 5000);
            
            return;
        }
        
        var credential = uniqueCredentials[index];
        var affectedRows = rowGroups[credential.key] || [];
        
        // Show spinners in all affected rows
        affectedRows.forEach(function(item) {
            item.statusCell.html('<span class="text-muted"><i class="fa fa-spinner fa-spin"></i> Validating...</span>');
        });
        
        // Update status indicator
        $('#smtp-validation-status').html(`SMTP Validation: ${index + 1}/${uniqueCount} credential sets ` +
                                         '<i class="fa fa-spinner fa-spin"></i>');
        
        // Validate using the credentials directly
        $.ajax({
            url: admin_url + 'ma/direct_smtp_test',
            type: 'POST',
            data: {
                email: credential.email,
                password: credential.password
            },
            dataType: 'json',
            timeout: 20000,
            success: function(response) {
                if (response && response.success) {
                    // Update all affected rows with the result
                    affectedRows.forEach(function(item) {
                        if (response.is_valid) {
                            // SMTP is valid, keep the original success status
                            //item.statusCell.html(item.originalHtml);
                            item.statusCell.html(`<span class="text-success">${credential.email}</span>`);
                        } else {
                            // SMTP failed validation, update to error
                            item.statusCell.html(`<span class="text-danger">${credential.email} (SMTP Error)</span>`);
                            item.row.removeClass('has-row-options').addClass('danger has-row-options');
                        }
                    });
                    
                    console.log(`Validated credential set ${index + 1}/${uniqueCount} (${credential.email}): ${response.is_valid ? 'Valid' : 'Invalid'}`);
                } else {
                    // Request failed, restore original content
                    affectedRows.forEach(function(item) {
                        item.statusCell.html(item.originalHtml);
                    });
                    
                    console.error(`Validation failed for credential set ${index + 1}: ${response ? response.message : 'Unknown error'}`);
                }
                
                // Proceed to next credential set
                setTimeout(function() {
                    validateNextCredential(index + 1);
                }, 1000);
            },
            error: function(xhr, status, error) {
                console.error(`AJAX error validating credential set ${index + 1}:`, status, error);
                
                // Restore original content for all affected rows
                affectedRows.forEach(function(item) {
                    item.statusCell.html(item.originalHtml);
                });
                
                // Continue to next credential
                setTimeout(function() {
                    validateNextCredential(index + 1);
                }, 2000);
            }
        });
    }
    
    // Start validation process
    validateNextCredential(0);
}