<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Sms_vilpower extends App_sms
{
    // Account SID from vilpower.com/console
    private $sid;

    // Auth Token from vilpower.com/console
    private $token;

    // Twilio Phone Number
    private $phone;

    // Alphanumeric Sender ID
    private $senderId;

    public function __construct()
    {
        parent::__construct();

        $this->sid      = $this->get_option('vilpower', 'account_sid');
        $this->token    = $this->get_option('vilpower', 'auth_token');
        $this->phone    = $this->get_option('vilpower', 'phone_number');
        $this->senderId = $this->get_option('vilpower', 'sender_id');

        $this->add_gateway('vilpower', [
            'name'    => 'VilPower',
            'info'    => '<p>VilPower supports <strong>one-way messaging</strong>, which means recipients will <strong>not be able to reply</strong> to SMS messages.
  Ensure that all phone numbers are formatted in 
  <a href="https://www.vilpower.com/docs/glossary/what-e164" target="_blank">E.164 format</a> for compatibility.
  For more details on how to correctly format international phone numbers, click 
  <a href="https://support.vilpower.com/hc/en-us/articles/223183008-Formatting-International-Phone-Numbers" target="_blank">here</a>.
</p>',
            'options' => [
                [
                    'name'  => 'account_sid',
                    'label' => 'Mobile No',
                ],
                [
                    'name'  => 'auth_token',
                    'label' => 'Password',
                ],
                [
                    'name'     => 'sender_id',
                    'label'    => 'Alphanumeric Sender ID',
                        'info' => '<p><a href="https://www.vilpower.com/blog/personalize-sms-alphanumeric-sender-id" target="_blank">https://www.vilpower.com/blog/personalize-sms-alphanumeric-sender-id</a></p>',
                ],
            ],
        ]);
    }

    public function send($number, $message)
    {
       
        $url = 'http://bulkpush.mytoday.com/BulkSms/SingleMsgApi';

        $params = [
            'feedid'   => '394530',
            'username' => '9740244801',
            'password' => 'STandard@26',
            'To'       => $this->phone,
            'text'     => $message
        ];
    
        $query = http_build_query($params);
        $final_url = $url . '?' . $query;
    
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $final_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
        $response = curl_exec($ch);
    
        if (curl_errno($ch)) {
            log_message('error', 'SMS API Error: ' . curl_error($ch));
        } else {
            log_message('info', 'SMS sent to ' . $this->phone . ': ' . $response);
        }
    
        curl_close($ch);
    
        return $response;

        // try {
        //     $client = new Twilio\Rest\Client($this->sid, $this->token);
        // } catch (Exception $e) {
        //     $this->set_error($e->getMessage(), false);

        //     return false;
        // }

        // try {
        //     $client->messages->create(
        //         // The number to send the SMS
        //         $number,
        //         [
        //             'from' => $this->senderId ?: $this->phone,
        //             'body' => $message,
        //         ]
        //     );

        //     $this->logSuccess($number, $message);
        // } catch (Exception $e) {
        //     $this->set_error($e->getMessage());

        //     return false;
        // }

        // return true;
    }
}
